
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php wp_title('|',true,'right'); bloginfo('name'); ?></title>
  <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
  <header class="site-header">
    <div class="container" style="display:flex;align-items:center;justify-content:space-between;">
      <div class="brand" style="display:flex;align-items:center;gap:12px;">
        <?php if ( function_exists('the_custom_logo') && has_custom_logo() ) { the_custom_logo(); } else { ?>
          <img src="<?php echo get_template_directory_uri(); ?>/logo.png" alt="Nepmandu" style="height:48px;"/>
        <?php } ?>
        <div class="site-title"><?php bloginfo('name'); ?></div>
      </div>
      <nav class="nav">
        <?php wp_nav_menu(array('theme_location'=>'primary','container'=>false)); ?>
      </nav>
    </div>
  </header>
